<?php
use App\Csrf;
use App\Helpers;
use App\Modules;
use App\Response;
use App\Schema;
use App\DB;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') Response::redirect('?a=dashboard');
if (!Csrf::validate($_POST['_csrf'] ?? null)) {
    Response::flash('error', 'CSRF inválido.');
    Response::redirect('?a=module_create');
}

$name = trim((string)($_POST['name'] ?? ''));
$table = Helpers::slug((string)($_POST['table_name'] ?? ''));

if ($name === '' || strlen($name) < 2) {
    Response::flash('error', 'Nome inválido.');
    Response::redirect('?a=module_create');
}

if (!Helpers::validIdentifier($table)) {
    Response::flash('error', 'Identificador de tabela inválido. Use letras/números/_ e comece com letra/_');
    Response::redirect('?a=module_create');
}

try {
    $id = Modules::create($name, $table);
    Schema::createDataTable(DB::pdo(), $table);
    Response::flash('success', 'Módulo criado. Agora adicione campos.');
    Response::redirect('?a=fields&module_id=' . $id);
} catch (Throwable $e) {
    Response::flash('error', 'Erro ao criar módulo: ' . $e->getMessage());
    Response::redirect('?a=module_create');
}
