<?php
use App\Csrf;
use App\Modules;
use App\Response;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') Response::redirect('?a=dashboard');
if (!Csrf::validate($_POST['_csrf'] ?? null)) {
    Response::flash('error', 'CSRF inválido.');
    Response::redirect('?a=dashboard');
}

$id = (int)($_POST['id'] ?? 0);
$name = trim((string)($_POST['name'] ?? ''));

if (!$id || $name === '' || strlen($name) < 2) {
    Response::flash('error', 'Dados inválidos.');
    Response::redirect('?a=dashboard');
}

Modules::update($id, $name);
Response::flash('success', 'Módulo atualizado.');
Response::redirect('?a=dashboard');
