<?php
namespace App;

final class Auth {
    public static function check(): bool {
        return !empty($_SESSION['user_id']);
    }

    public static function attempt(string $username, string $password): bool {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT id, password_hash FROM users WHERE username = ?");
        $stmt->execute([$username]);
        $row = $stmt->fetch();

        if (!$row) return false;
        if (!password_verify($password, $row['password_hash'])) return false;

        $_SESSION['user_id'] = (int)$row['id'];
        $_SESSION['username'] = $username;
        return true;
    }

    public static function logout(): void {
        $_SESSION = [];
        if (ini_get("session.use_cookies")) {
            $params = session_get_cookie_params();
            setcookie(session_name(), '', time() - 42000, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
        }
        session_destroy();
    }
}
