<?php
namespace App;

final class Env {
    public static function load(string $path): void {
        if (!is_file($path)) return;

        $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        if (!$lines) return;

        foreach ($lines as $line) {
            $line = trim($line);
            if ($line === '' || str_starts_with($line, '#')) continue;

            $parts = explode('=', $line, 2);
            if (count($parts) !== 2) continue;

            $key = trim($parts[0]);
            $val = trim($parts[1]);

            if ($val !== '' && (($val[0] === '"' && str_ends_with($val, '"')) || ($val[0] === "'" && str_ends_with($val, "'")))) {
                $val = substr($val, 1, -1);
            }

            $_ENV[$key] = $val;
        }
    }

    public static function get(string $key, ?string $default = null): ?string {
        return $_ENV[$key] ?? getenv($key) ?: $default;
    }
}
