<?php
namespace App;

final class Fields {

    public static function byModule(int $moduleId): array {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM fields WHERE module_id = ? ORDER BY position ASC, id ASC");
        $stmt->execute([$moduleId]);
        return $stmt->fetchAll();
    }

    public static function find(int $id): ?array {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("SELECT * FROM fields WHERE id = ?");
        $stmt->execute([$id]);
        $row = $stmt->fetch();
        return $row ?: null;
    }

    public static function create(int $moduleId, array $data): int {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("INSERT INTO fields (module_id, name, label, type, required, options, position) VALUES (?,?,?,?,?,?,?)");
        $stmt->execute([
            $moduleId,
            $data['name'],
            $data['label'],
            $data['type'],
            $data['required'],
            $data['options'],
            $data['position'],
        ]);
        return (int) $pdo->lastInsertId();
    }

    public static function update(int $id, array $data): void {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("UPDATE fields SET label = ?, type = ?, required = ?, options = ?, position = ? WHERE id = ?");
        $stmt->execute([
            $data['label'],
            $data['type'],
            $data['required'],
            $data['options'],
            $data['position'],
            $id
        ]);
    }

    public static function delete(int $id): void {
        $pdo = DB::pdo();
        $stmt = $pdo->prepare("DELETE FROM fields WHERE id = ?");
        $stmt->execute([$id]);
    }
}
