<?php
namespace App;

final class Response {
    public static function redirect(string $to): void {
        header("Location: {$to}");
        exit;
    }

    public static function flash(string $key, string $message): void {
        $_SESSION['_flash'][$key] = $message;
    }

    public static function pullFlash(string $key): ?string {
        $msg = $_SESSION['_flash'][$key] ?? null;
        if (isset($_SESSION['_flash'][$key])) unset($_SESSION['_flash'][$key]);
        return $msg;
    }
}
