<?php
namespace App;

use PDO;

final class Schema {

    public static function dataTable(string $tableName): string {
        return 'data_' . $tableName;
    }

    public static function sqlType(string $fieldType): string {
        return match ($fieldType) {
            'text'     => 'VARCHAR(255) NULL',
            'email'    => 'VARCHAR(255) NULL',
            'number'   => 'INT NULL',
            'date'     => 'DATE NULL',
            'datetime' => 'DATETIME NULL',
            'checkbox' => 'TINYINT(1) NOT NULL DEFAULT 0',
            'select'   => 'VARCHAR(255) NULL',
            'textarea' => 'TEXT NULL',
            default    => 'VARCHAR(255) NULL',
        };
    }

    public static function createDataTable(PDO $pdo, string $tableName): void {
        $full = self::dataTable($tableName);
        if (!Helpers::validIdentifier($full)) throw new \RuntimeException("Nome de tabela inválido.");
        $pdo->exec("CREATE TABLE IF NOT EXISTS `{$full}` (
            `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
            `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
            `updated_at` DATETIME NULL,
            PRIMARY KEY (`id`)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    }

    public static function addColumn(PDO $pdo, string $tableName, string $colName, string $fieldType): void {
        $full = self::dataTable($tableName);
        if (!Helpers::validIdentifier($full) || !Helpers::validIdentifier($colName)) {
            throw new \RuntimeException("Identificador inválido.");
        }
        $sqlType = self::sqlType($fieldType);
        $pdo->exec("ALTER TABLE `{$full}` ADD COLUMN `{$colName}` {$sqlType}");
    }

    public static function dropColumn(PDO $pdo, string $tableName, string $colName): void {
        $full = self::dataTable($tableName);
        if (!Helpers::validIdentifier($full) || !Helpers::validIdentifier($colName)) {
            throw new \RuntimeException("Identificador inválido.");
        }
        $pdo->exec("ALTER TABLE `{$full}` DROP COLUMN `{$colName}`");
    }
}
