<?php
use App\Helpers;
use App\Csrf;

$title = "Novo módulo - " . Helpers::appName();
require __DIR__ . '/../partials/header.php';
?>
<h1 class="h4 mb-3">Criar módulo</h1>

<div class="card shadow-sm">
  <div class="card-body">
    <form method="post" action="?a=module_store">
      <input type="hidden" name="_csrf" value="<?= Helpers::e(Csrf::token()) ?>">
      <div class="mb-3">
        <label class="form-label">Nome do módulo</label>
        <input class="form-control" name="name" placeholder="Ex: Clientes" required>
      </div>
      <div class="mb-3">
        <label class="form-label">Identificador da tabela (sem espaços)</label>
        <input class="form-control code" name="table_name" placeholder="ex: clientes" required>
        <div class="form-text">Vai virar a tabela <span class="code">data_clientes</span>.</div>
      </div>
      <button class="btn btn-primary">Criar</button>
      <a class="btn btn-link" href="?a=dashboard">Cancelar</a>
    </form>
  </div>
</div>
<?php require __DIR__ . '/../partials/footer.php'; ?>
