<?php
use App\Helpers;
use App\Auth;
use App\Response;

$title = $title ?? Helpers::appName();
?>
<!doctype html>
<html lang="pt-br">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?= Helpers::e($title) ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
  <style>
    .container-narrow{max-width:1100px}
    .code{font-family: ui-monospace, SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace;}
  </style>
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container container-narrow">
    <a class="navbar-brand" href="?a=dashboard"><?= Helpers::e(Helpers::appName()) ?></a>
    <div class="ms-auto d-flex gap-2">
      <?php if (Auth::check()): ?>
        <a class="btn btn-sm btn-outline-light" href="?a=modules">Módulos</a>
        <a class="btn btn-sm btn-outline-light" href="?a=logout">Logout</a>
      <?php endif; ?>
    </div>
  </div>
</nav>
<main class="container container-narrow py-4">
<?php if ($msg = Response::pullFlash('success')): ?>
  <div class="alert alert-success"><?= Helpers::e($msg) ?></div>
<?php endif; ?>
<?php if ($msg = Response::pullFlash('error')): ?>
  <div class="alert alert-danger"><?= Helpers::e($msg) ?></div>
<?php endif; ?>
