<?php
use App\Helpers;
use App\Modules;
use App\Fields;
use App\Records;
use App\Response;

$moduleId = (int)($_GET['module_id'] ?? 0);
$module = Modules::find($moduleId);
if (!$module) {
  Response::flash('error', 'Módulo não encontrado.');
  Response::redirect('?a=dashboard');
}

$fields = Fields::byModule($moduleId);
$rows = Records::list($module['table_name'], 200);

$title = "Registros - " . Helpers::appName();
require __DIR__ . '/../partials/header.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <div>
    <h1 class="h4 mb-1">Registros</h1>
    <div class="text-muted small">Módulo: <strong><?= Helpers::e($module['name']) ?></strong></div>
  </div>
  <div class="d-flex gap-2">
    <a class="btn btn-outline-primary" href="?a=fields&module_id=<?= (int)$moduleId ?>">Campos</a>
    <a class="btn btn-primary" href="?a=record_create&module_id=<?= (int)$moduleId ?>">+ Novo registro</a>
  </div>
</div>

<div class="card shadow-sm">
  <div class="card-body">
    <?php if (!$rows): ?>
      <div class="alert alert-info mb-0">Nenhum registro cadastrado.</div>
    <?php else: ?>
      <div class="table-responsive">
        <table class="table table-sm align-middle">
          <thead>
            <tr>
              <th>ID</th>
              <?php foreach ($fields as $f): ?>
                <th><?= Helpers::e($f['label']) ?></th>
              <?php endforeach; ?>
              <th class="text-end">Ações</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= (int)$r['id'] ?></td>
                <?php foreach ($fields as $f): 
                  $val = $r[$f['name']] ?? '';
                  if ($f['type'] === 'checkbox') $val = ((int)$val) ? 'Sim' : 'Não';
                ?>
                  <td><?= Helpers::e((string)$val) ?></td>
                <?php endforeach; ?>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-secondary" href="?a=record_edit&module_id=<?= (int)$moduleId ?>&id=<?= (int)$r['id'] ?>">Editar</a>
                  <a class="btn btn-sm btn-outline-danger" href="?a=record_delete&module_id=<?= (int)$moduleId ?>&id=<?= (int)$r['id'] ?>" onclick="return confirm('Excluir este registro?')">Excluir</a>
                </td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    <?php endif; ?>
  </div>
</div>

<a class="btn btn-link mt-3" href="?a=dashboard">← Voltar</a>
<?php require __DIR__ . '/../partials/footer.php'; ?>
