<?php
declare(strict_types=1);

require __DIR__ . '/../app/init.php';

use App\Auth;
use App\Response;

$action = $_GET['a'] ?? 'dashboard';

if (!Auth::check() && !in_array($action, ['login', 'do_login', 'install'])) {
    Response::redirect('?a=login');
}

switch ($action) {
    case 'login':
        require __DIR__ . '/../app/views/login.php';
        break;

    case 'do_login':
        require __DIR__ . '/../app/handlers/do_login.php';
        break;

    case 'logout':
        require __DIR__ . '/../app/handlers/logout.php';
        break;

    case 'dashboard':
        require __DIR__ . '/../app/views/dashboard.php';
        break;

    // Modules
    case 'modules':
        require __DIR__ . '/../app/views/modules/list.php';
        break;

    case 'module_create':
        require __DIR__ . '/../app/views/modules/create.php';
        break;

    case 'module_store':
        require __DIR__ . '/../app/handlers/modules/store.php';
        break;

    case 'module_edit':
        require __DIR__ . '/../app/views/modules/edit.php';
        break;

    case 'module_update':
        require __DIR__ . '/../app/handlers/modules/update.php';
        break;

    case 'module_delete':
        require __DIR__ . '/../app/handlers/modules/delete.php';
        break;

    // Fields
    case 'fields':
        require __DIR__ . '/../app/views/fields/list.php';
        break;

    case 'field_create':
        require __DIR__ . '/../app/views/fields/create.php';
        break;

    case 'field_store':
        require __DIR__ . '/../app/handlers/fields/store.php';
        break;

    case 'field_edit':
        require __DIR__ . '/../app/views/fields/edit.php';
        break;

    case 'field_update':
        require __DIR__ . '/../app/handlers/fields/update.php';
        break;

    case 'field_delete':
        require __DIR__ . '/../app/handlers/fields/delete.php';
        break;

    // Data CRUD
    case 'records':
        require __DIR__ . '/../app/views/records/list.php';
        break;

    case 'record_create':
        require __DIR__ . '/../app/views/records/create.php';
        break;

    case 'record_store':
        require __DIR__ . '/../app/handlers/records/store.php';
        break;

    case 'record_edit':
        require __DIR__ . '/../app/views/records/edit.php';
        break;

    case 'record_update':
        require __DIR__ . '/../app/handlers/records/update.php';
        break;

    case 'record_delete':
        require __DIR__ . '/../app/handlers/records/delete.php';
        break;

    default:
        http_response_code(404);
        echo "404 - ação não encontrada";
        break;
}
